 /* 'mrWindows.h' */

 /* Nagowki typw bazowych Mirus */
#include "mrDatatypes.h"
#include "mrError.h"
/* Plik nagwka Windows */
#include <windows.h> 

 /* Zacz plik tylko raz */
#pragma once

 /* Szkielet okna Mirus */
class mrWindow
{
protected:
 WNDCLASS  m_kWndClass;
 HWND      m_hWindow;
 MSG       m_kMessage;

public:
	/* Konstruktor / Destruktor */
 mrWindow (void);
 ~mrWindow (void);

  /* Funkcje manipulacji oknem */
 mrError32 Create (HINSTANCE hInstance, LPSTR szTitle, 
                   mrInt iWidth = CW_USEDEFAULT, 
                   mrInt iHeight = CW_USEDEFAULT, 
                   mrUInt32 iStyle = WS_OVERLAPPEDWINDOW | WS_VISIBLE);
 static LRESULT CALLBACK WndProc (HWND hWindow, UINT iMessage, 
                         WPARAM wParam, LPARAM lParam);
 void Run (void);

  /* Funkcje wasne */
 virtual mrBool32 MessageHandler (UINT iMessage, WPARAM wParam, 
                                  LPARAM lParam);
 virtual mrBool32 Frame (void) = 0;

  /* Dodatkowe funkcje */
 void SetPosition (mrInt iWidth, mrInt iHeight);
 POINT GetPosition (void);
 void SetSize (mrInt iWidth, mrInt iHeight);
 POINT GetSize (void);
 void Show (mrInt iShow);
};